//
//  Environment.swift
//  Do It
//
//  Created by Jim Dovey on 3/28/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import SwiftUI
#if canImport(UIKit)
import UIKit
#endif

#if canImport(UIKit)
enum InterfaceIdiom {
    case unspecified
    case phone
    case pad
    case tv
    case car
    
    init(_ idiom: UIUserInterfaceIdiom) {
        switch idiom {
        case .unspecified: self = .unspecified
        case .phone: self = .phone
        case .pad: self = .pad
        case .tv: self = .tv
        case .carPlay: self = .car
        @unknown default: self = .unspecified
        }
    }
}

struct InterfaceIdiomEnvironmentKey: EnvironmentKey {
    typealias Value = InterfaceIdiom
    static var defaultValue: InterfaceIdiom = .unspecified
}

extension EnvironmentValues {
    var interfaceIdiom: InterfaceIdiom {
        get { self[InterfaceIdiomEnvironmentKey.self] }
        set { self[InterfaceIdiomEnvironmentKey.self] = newValue }
    }
}
#endif
